/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.HorizontalConnectedBlock;
import cloud.lemonslice.teastory.block.crops.PaddyFieldBlock;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class AqueductBlock
extends HorizontalConnectedBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)0, (int)32);
    public static final BooleanProperty BLOCKED = BooleanProperty.m_61465_((String)"blocked");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static VoxelShape[] SHAPES;
    protected static final VoxelShape FULL_SHAPE;

    public AqueductBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(32))).m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(false)));
            level.m_186460_(pos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)level));
            if (!level.m_5776_()) {
                AqueductBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.f_49994_));
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(handIn).m_41720_() == Blocks.f_49994_.m_5456_() && !((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(32)));
            if (level instanceof ServerLevel) {
                this.updateWater((ServerLevel)level, pos.m_122012_(), state);
                this.updateWater((ServerLevel)level, pos.m_122019_(), state);
                this.updateWater((ServerLevel)level, pos.m_122029_(), state);
                this.updateWater((ServerLevel)level, pos.m_122024_(), state);
            }
            player.m_21120_(handIn).m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return this.fillAqueduct(level, pos, player, handIn);
    }

    public InteractionResult fillAqueduct(Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (player.m_21120_(handIn).m_204117_(Tags.Items.COBBLESTONE)) {
            worldIn.m_46597_(pos, Blocks.f_50652_.m_49966_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            return FULL_SHAPE;
        }
        int bottom = (Boolean)state.m_61143_((Property)BOTTOM) != false ? 0 : 16;
        int north = (Boolean)state.m_61143_((Property)NORTH) != false ? 0 : 8;
        int south = (Boolean)state.m_61143_((Property)SOUTH) != false ? 0 : 4;
        int west = (Boolean)state.m_61143_((Property)WEST) != false ? 0 : 2;
        int east = (Boolean)state.m_61143_((Property)EAST) != false ? 0 : 1;
        return SHAPES[bottom + north + south + west + east];
    }

    public boolean canConnect(BlockState state) {
        return AqueductBlock.isAqueduct(state) || state.m_60819_().m_76152_() == Fluids.f_76193_ && !(state.m_60734_() instanceof PaddyFieldBlock);
    }

    public static boolean isAqueduct(BlockState state) {
        return state.m_60734_() instanceof AqueductBlock;
    }

    public int getNearDistance(ServerLevel world, BlockPos pos) {
        int distance = 31;
        distance = Math.min(distance, this.getDistance(world.m_8055_(pos.m_122012_()), false));
        distance = Math.min(distance, this.getDistance(world.m_8055_(pos.m_122019_()), false));
        distance = Math.min(distance, this.getDistance(world.m_8055_(pos.m_122029_()), false));
        distance = Math.min(distance, this.getDistance(world.m_8055_(pos.m_122024_()), false));
        distance = Math.min(distance, this.getDistance(world.m_8055_(pos.m_7494_()), true));
        return distance;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(level, pos, state, player);
        return level.m_7731_(pos, Blocks.f_50016_.m_49966_(), level.m_5776_() ? 11 : 3);
    }

    public int getDistance(BlockState state, boolean isUp) {
        if (!this.canConnect(state) || state.m_60734_() instanceof AqueductBlock && ((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            return 32;
        }
        if (!isUp) {
            if (state.m_60734_() instanceof AqueductBlock) {
                return (Integer)state.m_61143_((Property)DISTANCE);
            }
            Fluid fluid = state.m_60819_().m_76152_();
            if (fluid == Fluids.f_76193_ && !(state.m_60734_() instanceof PaddyFieldBlock)) {
                return -1;
            }
        } else {
            Fluid fluid = state.m_60819_().m_76152_();
            if (fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_) {
                return -1;
            }
        }
        return 32;
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos) {
        BlockState state = this.m_49966_();
        FluidState up = world.m_8055_(pos.m_7494_()).m_60819_();
        if (up.m_76152_() == Fluids.f_76193_ || up.m_76152_() == Fluids.f_76192_) {
            state = (BlockState)((BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos facingPos = pos.m_121945_(facing);
            BlockState facingState = world.m_8055_(facingPos);
            if (!this.canConnect(facingState)) continue;
            state = (BlockState)state.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(true));
        }
        BlockPos facingPos = pos.m_121945_(Direction.DOWN);
        BlockState facingState = world.m_8055_(facingPos);
        if (AqueductBlock.isAqueduct(facingState)) {
            state = (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return this.getStateForPlacement(world, pos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        super.m_213897_(state, level, pos, randomSource);
        boolean flag = false;
        int nearDistance = this.getNearDistance(level, pos);
        int currentDistance = (Integer)state.m_61143_((Property)DISTANCE);
        if (((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            return;
        }
        if (nearDistance + 1 < currentDistance) {
            state = (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(nearDistance + 1));
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            this.updateConnected(level, pos, state);
            flag = true;
        } else if (nearDistance + 1 != currentDistance) {
            state = (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(32));
            this.updateConnected(level, pos, state);
            flag = true;
        }
        if (flag) {
            level.m_46597_(pos, state);
            this.updateWater(level, pos, state);
        }
    }

    public void updateConnected(ServerLevel worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            this.updateWater(worldIn, pos.m_122012_(), state);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            this.updateWater(worldIn, pos.m_122019_(), state);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            this.updateWater(worldIn, pos.m_122029_(), state);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            this.updateWater(worldIn, pos.m_122024_(), state);
        }
        if (((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
            this.updateWater(worldIn, pos.m_7495_(), state);
        }
    }

    public void updateWater(ServerLevel level, BlockPos pos, BlockState origin) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof PaddyFieldBlock) {
            level.m_46597_(pos, (BlockState)state.m_61124_(PaddyFieldBlock.WATER, (Comparable)((Object)((Boolean)origin.m_61143_((Property)WATERLOGGED) != false ? PaddyFieldBlock.Water.POUR : PaddyFieldBlock.Water.DRAIN))));
            ((PaddyFieldBlock)state.m_60734_()).updateWater(level, pos);
        } else if (state.m_60734_() instanceof AqueductBlock) {
            level.m_186460_(pos, state.m_60734_(), Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        super.m_6807_(state, level, pos, state1, b);
        level.m_186460_(pos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)level));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!(facingState.m_60734_() instanceof AqueductBlock) && !(facingState.m_60734_() instanceof PaddyFieldBlock)) {
            level.m_186460_(currentPos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)level) / 2);
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState)));
        } else if (facing == Direction.DOWN) {
            stateIn = (BlockState)stateIn.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(AqueductBlock.isAqueduct(facingState)));
        }
        return stateIn;
    }

    public boolean m_7361_(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public ItemStack m_142598_(LevelAccessor accessor, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{DISTANCE, BLOCKED, BOTTOM, WATERLOGGED}));
    }

    static {
        FULL_SHAPE = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);
        VoxelShape POST_0 = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 0.0, 4.0, 12.0, 4.0);
        VoxelShape POST_1 = VoxelShapeHelper.createVoxelShape(12.0, 4.0, 0.0, 4.0, 12.0, 4.0);
        VoxelShape POST_2 = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 12.0, 4.0, 12.0, 4.0);
        VoxelShape POST_3 = VoxelShapeHelper.createVoxelShape(12.0, 4.0, 12.0, 4.0, 12.0, 4.0);
        VoxelShape BOTTOM = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 4.0, 16.0);
        VoxelShape BOTTOM_OPTIONAL = VoxelShapeHelper.createVoxelShape(4.0, 0.0, 4.0, 8.0, 4.0, 8.0);
        VoxelShape DEFAULT = Shapes.m_83124_((VoxelShape)POST_0, (VoxelShape[])new VoxelShape[]{POST_1, POST_2, POST_3, Shapes.m_83113_((VoxelShape)BOTTOM, (VoxelShape)BOTTOM_OPTIONAL, (BooleanOp)BooleanOp.f_82685_)});
        VoxelShape WALL_NORTH = VoxelShapeHelper.createVoxelShape(4.0, 4.0, 0.0, 8.0, 12.0, 4.0);
        VoxelShape WALL_SOUTH = VoxelShapeHelper.createVoxelShape(4.0, 4.0, 12.0, 8.0, 12.0, 4.0);
        VoxelShape WALL_WEST = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 4.0, 4.0, 12.0, 8.0);
        VoxelShape WALL_EAST = VoxelShapeHelper.createVoxelShape(12.0, 4.0, 4.0, 4.0, 12.0, 8.0);
        SHAPES = new VoxelShape[]{DEFAULT, Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_EAST).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_WEST).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST}).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_SOUTH).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH}).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_NORTH).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)BOTTOM_OPTIONAL).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_()};
    }
}

